	PROCESSOR 16F887
	#include <P16F887.inc>
	__CONFIG	_CONFIG1, 020C4h
	__CONFIG	_CONFIG2, _WRT_OFF & _BOR21V
	CBLOCK 0x20
	TEMP_STATUS		;   STATUS    
	COUNT
	SendBait1 ; 1     LM7001
	SendBait2 ; 2     LM7001
	SendBait3 ; 3     LM7001


	READADR   ;   SendBait   
	Registr   ;    
	Registr2   ;    

	FmPcDrbezg ;     FM/PC  
	UartReg ;      Uart
	UartRegCom ;     Uart
	UartChar ;    Uart
	UartComRegistr ;  /   
	UartComRegistr2 ;  /   
	UartSendComType ;   : K -    , Y-   ,
	UartSendComValue ;   
	EncoderReg ;   

	AdcStatus ;   
	WheelKeyDrbezg ;     
	WheelKeySendCode;        
	ModeKeySendCode ;      MODE,      WheelKeySendCode
	EnVolumeOld	;     
	EnStationOld 	;      
	ModeTimer1 ;           Mode
	EyeTimer ;   4   

	dataL
	endc 

	W_Temp	equ 0x70		;   W    

	#DEFINE CeLm PORTB, 0 ;   LM7001
	#DEFINE DataLm PORTB, 1 ;   LM7001
	#DEFINE ClockLm PORTB, 2 ;   LM7001

	#DEFINE SaveVolume PORTB, 3 ;     1    

	#DEFINE EnStationUp PORTB, 5 ;    A( )
	#DEFINE EnStationDown PORTB, 4 ;   B ( )

	#DEFINE EnVolueUp PORTB, 7 ;   A ( )
	#DEFINE EnVolueDown PORTB, 6 ;   B ( )

	#DEFINE FmPcDiod PORTD, 0 ;    PC  
	#DEFINE FmPcCmd PORTD, 1 ;    PC  

	#DEFINE KeyStatus_NextKeyDown Registr, 0 ;    1    ,    
	#DEFINE KeyStatus_PrevKeyDown Registr, 1 ;    1    ,    
	#DEFINE KeyStatus_ModeKeyDown Registr, 2 ;    1  Mode ,          		
	#DEFINE I2CReset Registr, 3 ;  	
	#DEFINE I2CReset1 Registr, 4 ;  
	#DEFINE ReadPcAmpiler Registr, 5 ;    1      PC
	#DEFINE ReadPcMemory Registr, 6 ;    1     PC
	#DEFINE WriteFrequencyTuner Registr, 7 ;    1        

	#DEFINE SaveVolumeSet Registr2, 0 ;    1          
	
	#DEFINE	KeyStatus_FmPc Registr2, 2 ;          FM\PC

	#DEFINE WriteMemoryTuner UartComRegistr, 0 ;    1           
	#DEFINE SendComUart UartComRegistr, 1 ;    1     ,  0       
	#DEFINE Chr_C_SendCom UartComRegistr, 2 ;   1   "",     
	#DEFINE Chr_o_SendCom UartComRegistr, 3 ;   1   "0",     
	#DEFINE Chr_m_SendCom UartComRegistr, 4 ;   1   "m",     
	#DEFINE TypeCom_SendCom UartComRegistr, 5 ;   1     (K -    , Y-   , -   )
	#DEFINE Com_SendCom UartComRegistr, 6 ;   1     ,       ()
	#DEFINE SendComMemoryUart UartComRegistr, 7 ;    1      ,  0       

	#DEFINE Bait1_SendCom UartComRegistr2, 0  ;   1   1    ,      ()
	#DEFINE Bait2_SendCom UartComRegistr2, 1  ;   1   2    ,      ()
	#DEFINE Bait3_SendCom UartComRegistr2, 2  ;   1   3    ,      ()

	#DEFINE WhelKeyDown AdcStatus, 0 ;   1     
	;#DEFINE VolumePlusKeyDown AdcStatus, 1 ;    1     
	;#DEFINE VolumeMinusKeyDown AdcStatus, 2 ;    1     
	#DEFINE ModeKeyDown AdcStatus, 3 ;    1    
	#DEFINE ModeShotKeyDown AdcStatus, 4 ;    1     
	#DEFINE ModeLongKeyDown AdcStatus, 5 ;    1     
	#DEFINE PrevKeyDown AdcStatus, 6 ;    1     
	#DEFINE NextKeyDown AdcStatus, 7 ;    1     

	#DEFINE TempValumeClockwise EncoderReg, 0 ;    1      ,  
	#DEFINE ValumeClockwise EncoderReg, 1 ;    1      ,     
	#DEFINE TempValumeounterlockwise EncoderReg, 2 ;    1      ,  
	#DEFINE Valumeounterlockwise EncoderReg, 3 ;    1      ,     

	#DEFINE TempStationClockwise EncoderReg, 4 ;    1       ,  
	#DEFINE StationClockwise EncoderReg, 5 ;    1       ,     
	#DEFINE TempStationounterlockwise EncoderReg, 6 ;    1       ,  
	#DEFINE Stationounterlockwise EncoderReg, 7 ;    1       ,     

	#DEFINE TransmitAttLR AmpilerSendReg,0 ;    1-   	SpeakerAttLR
	#DEFINE TransmitAttRR AmpilerSendReg,1 ;    1-   	SpeakerAttRR
	#DEFINE TransmitAttLF AmpilerSendReg,2 ;    1-   	SpeakerAttLF
	#DEFINE TransmitAttRF AmpilerSendReg,3 ;    1-   	SpeakerAttRF
	#DEFINE TransmitAudioSwitch AmpilerSendReg,4 ;    1-   	AudioSwitch
	#DEFINE TransmitBassCotrol AmpilerSendReg,5 ;    1-   	BassCotrol
	#DEFINE TransmitTrebleControl AmpilerSendReg,6 ;    1-   	TrebleControl

	org 0x000
	goto Start
	ORG 0x004 ; 
	goto Interupt

;**************************************************
; 
;**************************************************
Interupt:
	
	movwf W_Temp 
	SWAPF STATUS,w
	clrf STATUS
	MOVWF TEMP_STATUS

	btfsc PIR1,RCIF         
	goto IntUsartIn 	;     USart
	btfsc PIR1,ADIF         
	goto IntADC 	;    
	btfsc INTCON,RBIF
	goto IntEncoder ;      B
	btfsc INTCON,T0IF
	goto IntTMR0 ;     TMR0
	goto ExitInt

;**************************************************
;    USART
;**************************************************
IntUsartIn:
	bcf PIR1,RCIF
	movf RCREG,W
	movwf UartChar

	movfw UartReg
	addwf PCL,f 
	goto IntUsartInChar1 ;      "C"
	goto IntUsartInChar2 ;      "o"
	goto IntUsartInChar3 ;      "m"
	goto IntUsartInComType ;  4     T-   , -      , -   , R   
	goto IntUsartInComTuner ;   () 

IntUsartInComTuner:
	movfw UartRegCom
	addwf PCL,f 
	goto IntUsartInComTuner_Bayt1
	goto IntUsartInComTuner_Bayt2
	goto IntUsartInComTuner_Bayt3

IntUsartInChar1: ; 1   "C"
	movf UartChar,w
	sublw .67 ; C
	btfss STATUS,Z
	goto IntUsartChar1False
	goto IntUsartChar1True
IntUsartChar1False:
	goto ExitInt
IntUsartChar1True:
	movlw .1
	movwf UartReg
	goto ExitInt
IntUsartInChar2: ; 2   "o"
	movf UartChar,w
	sublw .111 ; o
	btfss STATUS,Z
	goto IntUsartChar2False
	goto IntUsartChar2True
IntUsartChar2False:
	clrf UartReg
	goto IntUsartInChar1
IntUsartChar2True:
	movlw .2
	movwf UartReg
	goto ExitInt
IntUsartInChar3: ; 3   "m"
	movf UartChar,w
	sublw .109 ; m
	btfss STATUS,Z
	goto IntUsartChar3False
	goto IntUsartChar3True
IntUsartChar3False:
	clrf UartReg
	goto IntUsartInChar1
IntUsartChar3True:
	movlw .3
	movwf UartReg
	goto ExitInt
IntUsartInComType: ;  4   T-   , -      , -   
	movf UartChar,w
	sublw .77 ; M
	btfss STATUS,Z
	goto IntUsartInComTypeM_False
	goto IntUsartInComTypeM_True
IntUsartInComTypeM_True:
	movlw .4
	movwf UartReg
	clrf UartRegCom
	goto ExitInt
IntUsartInComTypeM_False:
	movf UartChar,w
	sublw .65 ; A
	btfss STATUS,Z
	goto IntUsartInComTypeA_False
	goto IntUsartInComTypeA_True
IntUsartInComTypeA_True:
	movlw .5
	movwf UartReg
	goto ExitInt
IntUsartInComTypeA_False:

	movf UartChar,w
	sublw .84 ; T
	btfss STATUS,Z
	goto IntUsartInComTypeT_False
	goto IntUsartInComTypeT_True
IntUsartInComTypeT_True:
	movlw .7
	movwf UartReg
	clrf UartRegCom
	goto ExitInt
IntUsartInComTypeT_False:
	movf UartChar,w
	sublw .82 ; R
	btfss STATUS,Z
	goto IntUsartInComTypeR_False
	goto IntUsartInComTypeR_True
IntUsartInComTypeR_True:
	movlw .6
	movwf UartReg
	goto ExitInt
IntUsartInComTypeR_False:

	clrf UartReg
	goto IntUsartInChar1



IntUsartInComTuner_Bayt1: ;  1    ,    3-    3   
	movf UartChar,w
	movwf SendBait1
	movlw .1
	movwf UartRegCom
	goto ExitInt
IntUsartInComTuner_Bayt2: ;  2    ,    3-    3   
	movf UartChar,w
	movwf SendBait2
	movlw .2
	movwf UartRegCom
	goto ExitInt
IntUsartInComTuner_Bayt3: ;  3    ,    3-    3   
	movf UartChar,w
	movwf SendBait3
	clrf UartReg
	bsf WriteFrequencyTuner
	goto ExitInt


;**************************************************
;    
;**************************************************
IntADC: 
	bcf PIR1,ADIF
	btfss ADCON0,CHS0
	goto IntADCKey
;**************************************************
;    
;**************************************************
	bcf ADCON0,CHS0
	decfsz EyeTimer
	goto ExitIntADC
	movlw .37
	movwf EyeTimer

	goto ExitIntADC
;**************************************************
;    
;**************************************************
IntADCKey:
	btfss WhelKeyDown
	goto $+3
	decfsz WheelKeyDrbezg
	goto ExitIntADC

	bsf ADCON0,CHS0
	movf ADRESH, w
	addlw .96 ;  255-(159)
	addlw .13 ;    (-+1)	159-147+1 
	btfsc STATUS, C
	Goto VolumeDown ;   

	movf ADRESH, w
	addlw .122 ;  255-(133)
	addlw .13 ;    (-+1)	133-121+1 
	btfsc STATUS, C
	Goto VolumeUp ;   

	movf ADRESH, w
	addlw .173 ;  255-(82)
	addlw .13 ;    (-+1)	82-70+1 
	btfsc STATUS, C
	Goto Mode ;  Mode

	movf ADRESH, w
	addlw .198 ;  255-(57)
	addlw .13 ;    (-+1)	57-45+1 
	btfsc STATUS, C
	Goto PrevTrack ;   

	movf ADRESH, w
	addlw .224 ;  255-(31)
	addlw .13 ;    (-+1)	31-19+1 
	btfsc STATUS, C
	Goto NextTrack ;   

	;     
	bcf WhelKeyDown
	bcf KeyStatus_NextKeyDown
	bcf KeyStatus_PrevKeyDown
	bcf KeyStatus_ModeKeyDown
	movf ModeKeySendCode,w
	btfsc STATUS,Z
	goto ExitIntADC
	clrf ModeKeySendCode
	movwf WheelKeySendCode
	goto ExitIntADC
VolumeDown:
	btfsc WhelKeyDown
	goto $+5
	movlw .105
	movwf WheelKeyDrbezg
	bsf WhelKeyDown
	goto ExitIntADC
	bsf Valumeounterlockwise
	goto ExitIntADC
VolumeUp:
	btfsc WhelKeyDown
	goto $+5
	movlw .105
	movwf WheelKeyDrbezg
	bsf WhelKeyDown
	goto ExitIntADC
	bsf ValumeClockwise
	goto ExitIntADC
Mode:
	btfss KeyStatus_ModeKeyDown
	goto Mode1
	decfsz ModeTimer1
	goto ExitIntADC
	movlw .4
	movwf ModeKeySendCode
	movlw .1
	movwf ModeTimer1
	goto ExitIntADC
Mode1:
	btfsc WhelKeyDown
	goto $+5
	movlw .5
	movwf WheelKeyDrbezg
	bsf WhelKeyDown
	goto ExitIntADC
	bsf ModeKeyDown	
	movlw .3
	movwf ModeKeySendCode
	movlw .7
	movwf ModeTimer1
	bsf KeyStatus_ModeKeyDown
	goto ExitIntADC
PrevTrack:
	btfsc KeyStatus_PrevKeyDown
	goto ExitIntADC
	btfsc WhelKeyDown
	goto $+5
	movlw .5
	movwf WheelKeyDrbezg
	bsf WhelKeyDown
	goto ExitIntADC
	bsf KeyStatus_PrevKeyDown
	bsf PrevKeyDown
	movlw .1
	movwf WheelKeySendCode
	goto ExitIntADC
NextTrack:
	btfsc KeyStatus_NextKeyDown
	goto ExitIntADC
	btfsc WhelKeyDown
	goto $+5
	movlw .5
	movwf WheelKeyDrbezg
	bsf WhelKeyDown
	goto ExitIntADC
	bsf KeyStatus_NextKeyDown
	bsf NextKeyDown
	movlw .2
	movwf WheelKeySendCode
	goto ExitIntADC

ExitIntADC:
	;bsf ADCON0,GO ;    
 	goto ExitInt

;**************************************************
;     TMR0
;**************************************************
IntTMR0:
	bcf INTCON,T0IF
	bsf ADCON0,GO ;    
	btfsc I2CReset1
	BSF	PIR1,SSPIF
	btfsc I2CReset
	bsf I2CReset1
	goto ExitInt
;**************************************************
;      PORTB
;**************************************************
IntEncoder:
	movf PORTB,w
	bcf INTCON,RBIF
	andlw b'11000000'
;**************************************************
;     Volume  PORTB
;**************************************************
	xorwf EnVolumeOld, w
	bz IntEncoderStation
	xorwf   EnVolumeOld,W        ; restore WREG
	movwf   EnVolumeOld
IntEncoderValue:
	btfsc EnVolueUp
	goto EnVolue1
	btfsc EnVolueDown
	goto EnVolue2
	bcf TempValumeClockwise ;  
	bcf TempValumeounterlockwise ;  
	goto IntEncoderStation

EnVolue1:
	btfsc EnVolueDown
	goto EnVolue1_1
	goto EnVolue1_2
EnVolue1_1: ;    1:1
	goto IntEncoderStation
EnVolue1_2:
	btfss TempValumeClockwise
	goto EnVolue1_2_1
	goto EnVolue1_2_2
EnVolue1_2_1:
	btfsc TempValumeounterlockwise
	goto IntEncoderStation
	bsf TempValumeounterlockwise ; 
	bsf Valumeounterlockwise
	goto ExitInt
EnVolue1_2_2:
	bcf TempValumeClockwise ;  
	goto ExitInt
EnVolue2:
	btfsc EnVolueDown
	goto EnVolue2_1
	goto EnVolue2_2
EnVolue2_1:
	btfss TempValumeounterlockwise
	goto EnVolue2_2_1
	goto EnVolue2_2_2
EnVolue2_2_1:
	btfsc TempValumeClockwise
	goto IntEncoderStation
	bsf TempValumeClockwise  ; 
	bsf ValumeClockwise
	goto ExitInt
EnVolue2_2_2:
	bcf TempValumeounterlockwise ;  
	goto ExitInt
EnVolue2_2: ;    0:0
	goto IntEncoderStation

;**************************************************
;        PORTB
;**************************************************
IntEncoderStation:
	movf PORTB,w
	andlw b'00110000'
	xorwf 	EnStationOld, w
	bz ExitInt
	xorwf EnStationOld,W        ; restore WREG
	movwf EnStationOld

	btfsc EnStationUp
	goto EnStation1
	btfsc EnStationDown
	goto EnStation2
	goto ExitInt
EnStation1:
	btfsc EnStationDown
	goto EnStation1_1
	goto EnStation1_2
EnStation1_1: ;    1:1
	goto ExitInt
EnStation1_2:
	btfss TempStationClockwise
	goto EnStation1_2_1
	goto EnStation1_2_2
EnStation1_2_1:
	bsf TempStationounterlockwise ; 
	bsf Stationounterlockwise
	goto ExitInt
EnStation1_2_2:
	bcf TempStationClockwise ;  
	goto ExitInt
EnStation2:
	btfsc EnStationDown
	goto EnStation2_1
	goto EnStation2_2
EnStation2_1:
	btfss TempStationounterlockwise
	goto EnStation2_2_1
	goto EnStation2_2_2
EnStation2_2_1:
	bsf TempStationClockwise  ; 
	bsf StationClockwise
	goto ExitInt
EnStation2_2_2:
	bcf TempStationounterlockwise ;  
	goto ExitInt
EnStation2_2: ;    0:0
	goto ExitInt

ExitInt:
	MOVF W_Temp,w
	SWAPF TEMP_STATUS,w
	MOVWF STATUS
	bsf INTCON,GIE
	RETURN ;   

Start:
;**************************************************
;  
;**************************************************
	bcf STATUS,RP1
	bcf STATUS, RP0
	clrf PORTA
	clrf PORTB

	bsf       STATUS,RP0
  	bsf       STATUS,RP1          ; select Register Bank 3
	movlw     0xFF                ; we want all Port A pins Analog
	movwf     ANSEL
	movlw     0x00
	movwf     ANSELH              ; PortB pins are digitial (important as RB0 is switch)
	bcf       STATUS,RP1

	movlw b'11110000'
	movwf IOCB ;   B     
	movlw b'00010011' ;  
	movwf TRISA
	movlw b'11111000' ;  
	movwf TRISB
	MOVLW b'10011000' 
	MOVWF TRISC
	MOVLW b'11000010' 
	MOVWF TRISD
	MOVLW b'00000010' 
	MOVWF TRISE
	MOVLW b'01000000'     
	MOVWF OPTION_REG
	MOVLW b'11110000'     
	MOVWF WPUB

	bcf STATUS, RP0


;**************************************************
;  I2
;**************************************************
	BANKSEL	SSPCON2		; 
	MOVLW	b'01100000'	; Set ACKSTAT,ACKDT bits
	MOVWF	SSPCON2		; Reset SEN,ACK bits
	MOVLW	b'10000000'	;
	MOVWF	SSPSTAT		; Speed & signal levels
	MOVLW	0x13		; Clock = 50kHz	
	MOVWF	SSPADD		; Load baud rate count-1
	BANKSEL	SSPCON		; 	
	MOVLW	b'00101000'	;
	MOVWF	SSPCON		; Set mode & enable

;**************************************************
;  UART
;**************************************************
	bsf STATUS,RP0
	banksel BAUDCTL
	bcf  BAUDCTL,SCKP
	bcf STATUS,RP1			
	movlw 0x0C              ; 0x19=9600 bps (0x0C=19200 bps)
	movwf SPBRG
	movlw b'00100100'       ; brgh = high (2)
	movwf TXSTA         
	bcf STATUS,RP0          ; RAM PAGE 0
	bcf STATUS,RP1
	movlw b'10010000'       ; enable Async Reception
	movwf RCSTA
        
;**************************************************
;  
;**************************************************
	bsf STATUS, RP0
	movlw b'01101000' ;      , PORTB(RB4-RB7),TMR0   
	movwf INTCON
	movlw b'01100000'  ;     USART
	movwf PIE1
	bcf STATUS, RP0

;**************************************************
;  
;**************************************************
	bsf STATUS, RP0
	movlw b'00000100' ;   RA0, RA1, RA3   
	movwf ADCON1
	bcf STATUS, RP0
	movlw b'10000001'
	movwf ADCON0 ;   Fosc/32,   
	;bsf ADCON0,GO ;    

;**************************************************
;    
;**************************************************
	movlw .1
	movwf EyeTimer
	clrf Registr
	clrf Registr2
	clrf UartReg
	clrf UartRegCom

	clrf dataL
settle 
	decfsz dataL,F
	goto settle
	clrf dataL

	call message
	bsf INTCON,GIE		;   

	
Cycle:
;**************************************************
;  
;**************************************************

;**************************************************
;       
;**************************************************
	btfss WriteFrequencyTuner
	goto $+3
	bcf WriteFrequencyTuner
	call SendLM

;**************************************************
;      
;**************************************************
	btfsc SendComUart
	goto SendComNoEnd ;  
;**************************************************
;      FM/PC (+   )
;**************************************************
	MOVLW .10 ;    
	BTFSS KeyStatus_FmPc ;    ,   
	goto FmPc_Prtvios
	decfsz FmPcDrbezg
	goto FmPc_Next
	MOVLW .1 ;    
FmPc_Prtvios:
	BTFSS FmPcCmd 	;       FM/PC
	goto FmPc_KeyDown ;
	goto FmPc_KeyUp ; 
FmPc_KeyDown:
	MOVWF FmPcDrbezg ;   
	BTFSC KeyStatus_FmPc ;          
	goto FmPc_Next 
	bsf KeyStatus_FmPc
	movlw .7
	movwf WheelKeySendCode ;     pc
	goto FmPc_Next 
FmPc_KeyUp:
	bcf KeyStatus_FmPc
FmPc_Next:

;**************************************************
;      ,     
;**************************************************
	movf WheelKeySendCode,f
	btfsc STATUS,Z
	goto StationounterlockwiseCheck
	call InitSendKeyCode
;**************************************************
;       
;**************************************************
StationounterlockwiseCheck: 
	btfss Stationounterlockwise
	goto StationlockwiseCheck
StationounterlockwiseSendPC:
	movlw .22
	movwf WheelKeySendCode
	bcf Stationounterlockwise
;**************************************************
;       
;**************************************************
StationlockwiseCheck: 
	btfss StationClockwise
	goto ValumeounterlockwiseCheck
StationlockwiseSendPC:
	movlw .23
	movwf WheelKeySendCode
	bcf StationClockwise
;**************************************************
;       
;**************************************************
ValumeounterlockwiseCheck: 
	btfss Valumeounterlockwise
	goto ValumeClockwiseCheck
	movlw .20
	movwf WheelKeySendCode;    pc
	bcf Valumeounterlockwise
;**************************************************
;       
;**************************************************
ValumeClockwiseCheck: 
	btfss ValumeClockwise
	goto Exit
	movlw .21
	movwf WheelKeySendCode;    pc
	bcf ValumeClockwise
	goto Exit
;**************************************************
;    PC  
;**************************************************
SendComNoEnd:
	call send
	goto Exit
Exit:
;**************************************************
;   
;**************************************************
	goto Cycle



;**************************************************
;     LM7001 
;**************************************************
SendLM:
	;bcf INTCON,GIE
	bsf CeLm
	movlw .8
	movwf COUNT
SendLmBait1:
	bcf DataLm
	btfsc SendBait1,7
	bsf DataLm
	call SendClockLm
	rlf SendBait1,f
	decfsz COUNT,f
	goto SendLmBait1
	movlw .8
	movwf COUNT
SendLmBait2:
	bcf DataLm
	btfsc SendBait2,7
	bsf DataLm
	call SendClockLm
	rlf SendBait2,f
	decfsz COUNT,f
	goto SendLmBait2
	movlw .8
	movwf COUNT
SendLmBait3:
	bcf DataLm
	btfsc SendBait3,7
	bsf DataLm
	call SendClockLm
	rlf SendBait3,f
	decfsz COUNT,f
	goto SendLmBait3
	bcf DataLm
	bcf CeLm
	;bsf INTCON,GIE
	retlw 0

;**************************************************
;        LM7001 
;**************************************************
SendClockLm:
	bsf ClockLm
	nop
	nop
	nop
	bcf ClockLm
	return

;**************************************************
;   ,  W    
;**************************************************
ReadFrequency: 
	bcf INTCON,GIE
	MOVWF READADR
	ADDWF READADR,f
	ADDWF READADR,w	
	addlw 0x10
	MOVWF READADR
    bcf STATUS,RP0
	bsf STATUS,RP1
	MOVWF EEADR
	bsf STATUS,RP0
	bcf EECON1,EEPGD
	bsf EECON1,RD
	bcf STATUS,RP0
	movf EEDATA,W
	bcf STATUS,RP1
	MOVWF SendBait1
	incf READADR,w	
	MOVWF READADR
    bcf STATUS,RP0
	bsf STATUS,RP1
	MOVWF EEADR
	bsf STATUS,RP0
	bcf EECON1,EEPGD
	bsf EECON1,RD
	bcf STATUS,RP0
	movf EEDATA,W
	bcf STATUS,RP1
	MOVWF SendBait2
	incf READADR,w
    bcf STATUS,RP0
	bsf STATUS,RP1
	MOVWF EEADR
	bsf STATUS,RP0
	bcf EECON1,EEPGD
	bsf EECON1,RD
	bcf STATUS,RP0
	movf EEDATA,W
	bcf STATUS,RP1
	MOVWF SendBait3
	bsf INTCON,GIE
	return

;**************************************************
;        
;**************************************************
InitSendKeyCode:  
	bsf SendComUart 
	movlw 'K'
	movwf UartSendComType 
	movf WheelKeySendCode,w
	movwf UartSendComValue 
	clrf WheelKeySendCode
	bsf Chr_C_SendCom
	MOVLW 'C' 
	movwf TXREG ;   ""
	return


;**************************************************
;    
;**************************************************
send:
	bsf STATUS,RP0 ;  1
	btfss TXSTA,TRMT
	goto SendNoEnd
	bcf STATUS,RP0 ;  0
	btfss Chr_C_SendCom
	Goto Chr_C_SendComExit
	movlw 'o'
	movwf TXREG  ;   "o"
	bcf Chr_C_SendCom
	bsf Chr_o_SendCom
	goto SendNoEnd
Chr_C_SendComExit:
	btfss Chr_o_SendCom
	goto Chr_o_SendComExit
	movlw 'm'
	movwf TXREG
	bcf Chr_o_SendCom
	bsf Chr_m_SendCom
	goto SendNoEnd
Chr_o_SendComExit:
	btfss Chr_m_SendCom
	goto Chr_m_SendComExit
	movf UartSendComType,w
	movwf TXREG
	bcf Chr_m_SendCom
	bsf	TypeCom_SendCom
	goto SendNoEnd
Chr_m_SendComExit:
	btfss TypeCom_SendCom
	goto TypeCom_SendComExit
	movf UartSendComValue,w
	movwf TXREG
	bcf TypeCom_SendCom
	bsf	Com_SendCom
	goto SendNoEnd
TypeCom_SendComExit:
	bcf	Com_SendCom
	btfss ReadPcAmpiler
	goto ResetComUart


ResetComUart:
	bcf SendComUart

SendNoEnd:
	bcf STATUS,RP0 ;  0
	return


;**************************************************
;   Start I2C
;**************************************************
sencon		
	BANKSEL	PIR1
	BCF	PIR1,SSPIF	;   
	BANKSEL SSPCON2		; select register page
	BSF	SSPCON2,ACKSTAT ; Set acknowledge flag
	BSF	SSPCON2,SEN	; Generate start bit
	CALL	wint		; wait till done
;	MOVF	ConReg,W	;     W
	CALL	sendI2C		;   
	RETURN			

;**************************************************
;   Stop I2C
;**************************************************
senstop
	BANKSEL	SSPCON2		
	BSF	SSPCON2,PEN	;   
	CALL	wint		;  
	RETURN		

;**************************************************
;     I2C
;**************************************************
sendI2C		; Select.. 
	BANKSEL	SSPBUF		;  
	MOVWF	SSPBUF		; Send address/data
	CALL	wint		;  
	RETURN			

;**************************************************
;    SSPIF   I2C 
;**************************************************
wint	
	BANKSEL	PIR1 		; Select bank 
	BCF	PIR1,SSPIF	; reset interrupt flag
	bsf I2CReset
win	
	BTFSS	PIR1,SSPIF	; .. 
	GOTO	win		; .. 
	bcf I2CReset
	bcf I2CReset1
	RETURN			


send1    movwf TXREG             ; send data in W 

TransWt bsf STATUS,RP0		; RAM PAGE 1
WtHere  btfss TXSTA,TRMT        ; (1) transmission is complete if hi
        goto WtHere

        bcf STATUS,RP0          ; RAM PAGE 0
        return
;
; -------
; MESSAGE
; -------
;
message 
	movlw 	'1'		
	call	send1
	movlw 	'6'
	call	send1
	movlw 	'F'
	call	send1
	movlw 	'6'
	call	send1
	movlw 	'2'
	call	send1
	movlw 	'8'
	call	send1
	movlw 	' '
	call	send1
	movlw 	'a'
	call	send1
	movlw 	'l'
	call	send1
	movlw 	'i'
	call	send1
	movlw 	'v'
	call	send1
	movlw 	'e'
	call	send1
	movlw 	0x0D	; CR
	call	send1
	movlw 	0x0A	; LF 
	call	send1
	return
	
message1 
	movlw 	'O'		
	call	send1
	movlw 	'k'
	call	send1
	movlw 	0x0D	; CR
	call	send1
	movlw 	0x0A	; LF 
	call	send1
	return
	
message2 
	movlw 	'O'		
	call	send1
	movlw 	'k'
	call	send1
	movlw 	'T'
	call	send1
	movlw 	0x0D	; CR
	call	send1
	movlw 	0x0A	; LF 
	call	send1
	return
	
message3 
	movlw 	'E'		
	call	send1
	movlw 	'x'
	call	send1
	movlw 	'i'
	call	send1
	movlw 	'T'
	call	send1
	movlw 	0x0D	; CR
	call	send1
	movlw 	0x0A	; LF 
	call	send1
	return
	end


